/*
 * MINI SPI CAN CONTROL
 */

#ifndef mini_spi_can__h
#define mini_spi_can__h

/*
 * CAN Speed
 */
//#define F_CAN	        				16000000UL							//MCP2515 OSC = 16MHz
//#define F_CAN	        		20000000UL							//MCP2515 OSC = 20MHz

//BRP Setting in CNF1
#define CAN_1000kbps  			0       							// CAN speed at 1000 kbps
#define CAN_500kbps   			1       							// CAN speed at 500  kbps	
#define CAN_250kbps   			3   								// CAN speed at 250  kbps    	
#define CAN_125kbps   			7									// CAN speed at 125  kbps       	
#define CAN_62_5kbps   			9 									// CAN speed at 62.5 kbps

#define ENGINE_COOLANT_TEMP 	0x05
#define ENGINE_RPM          	0x0C
#define VEHICLE_SPEED       	0x0D
#define MAF_SENSOR          	0x10
#define O2_VOLTAGE          	0x14
#define THROTTLE				0x11

#define PID_REQUEST         	0x7DF
#define PID_REPLY				0x7E8

class CanbusClass
{
  public:

  CanbusClass();
  char init(unsigned char);
  //char message_tx(void);
  //char message_rx(unsigned char *buffer);
  char ecu_req(unsigned char pid,  char *buffer);

  private:	
};

extern CanbusClass mini_spi_can;

#endif
